#include "../common/structs.h"
#include "./bitmapUnix.h"
#include "./ppm.h"
#include "../common/debug.h"
#include <stdio.h>
#include <string.h>

extern scene_data *main_scene;

void setup_filename(char *extension)
{
	/* set up the filenames */
	printd(ALERT, "Creating outname\n");
	strncpy(main_scene->outname, main_scene->name, NAME_LENGTH);
	if( strstr(main_scene->name, ".txt") )
		   main_scene->outname[strlen(main_scene->name)-4] = '\0';
	strcat( main_scene->outname, extension);
}

int save_frame(scene_data* scene)
{
	printd(NORMAL, "writing file out\n");
	setup_filename(".ppm");
	return (int) write_ppm( scene->outname,
			scene->width, scene->height, scene->frame_buffer);

	setup_filename(".bmp");
	return (int) write24BitBmpFile( scene->outname,
			scene->width, scene->height, scene->frame_buffer);
}
	
